'use strict';

/* Controllers */

function BCPPriceListCtrl($scope, $rootScope, Company, $route, FrontCreatorCompanyForLoggedUser, CurrencyManager){

    Company.init();
    $scope.company = Company;

    $scope.Currency = CurrencyManager.list;

    $scope.methodType = 'bcp-priceList';
    $scope.number = /^\d+$/;
    $scope.percentPriceToCost = 300;

    $scope.init = function() {
        $scope.productPrice = $scope.company.production_price;
        if($scope.productPrice == ''){
            $scope.productPrice = 0;
        }
        $scope.startVal = $scope.productPrice;
        $scope.startChangeProductionCost = $scope.company.change_production_cost;
    }

    $scope.showToken = function() {
        var params = {};
        params.title = 'Cennik';
        params.tokensConfirmsMessage = 'controlPanel,'+'priceList';
        params.typeSubmitToken = 'REPRESENTATION';
        params.changes = [];
        if($scope.isChangedPrice()){
            params.changes.push('Cena produktu została zmieniona' + ' z ' + $scope.startVal + ' na ' + $scope.productPrice + '.');
        }
        if($scope.isChangedProductionCost()){
            params.changes.push('Zmiana kosztów wyprodukowania jednej sztuki towaru została zmieniona' + ' z ' + $scope.startChangeProductionCost + '% na ' + $scope.company.change_production_cost + '%.');
        }
        params.modal = true;

        $rootScope.$broadcast('Tokens:openSubmitTokensModal',$scope.company, params, $scope.methodType);
    }

    $scope.changedForSave = function(prodPrice){
        return ($scope.isChangedPrice() || $scope.isChangedProductionCost()) && prodPrice.$valid && $scope.validPrice();
    }

    $scope.$on('Tokens:closeSubmitTokensModal', function(event,methodType){
        if(methodType == $scope.methodType){
            $scope.company.production_price = $scope.productPrice;
            
            FrontCreatorCompanyForLoggedUser.save({data: $scope.company},function(data){
                $scope.company = data;
            });
            $scope.changes = [];

            $scope.startVal = $scope.company.production_price;
            $scope.startChangeProductionCost = $scope.company.change_production_cost;
        }
    });

    $scope.validPrice = function(){
        return (Number($scope.productPrice) <= (Number($scope.company.user_groups.user.market_segment.max_price)));
    }

    $scope.isChangedPrice = function(){
        return $scope.productPrice != $scope.startVal;
    }

    $scope.isChangedProductionCost = function(){
        return $scope.startChangeProductionCost != $scope.company.change_production_cost;
    }

    $scope.increaseVal = function() {
        $scope.productPrice = Number($scope.productPrice) + 1;
    }

    $scope.decreaseVal = function() {
        $scope.productPrice = Number($scope.productPrice) - 1;
    }

    $scope.getCurrency = function(symbol){
        var value = 1;
        for(var i=0;i<$scope.Currency.length;i++){
            if($scope.Currency[i].symbol == symbol){
                value = $scope.Currency[i].actualSession.close;
                break;
            }
        }
        return value;
    }

    $scope.getProductionCostWithChanges = function(){
        var productionCost = $scope.company.user_groups.user.market_segment.production_cost;
        return productionCost + productionCost * $scope.company.change_production_cost/100;
    }

}

BCPPriceListCtrl.$inject = ['$scope', '$rootScope', 'Company', '$route', 'FrontCreatorCompanyForLoggedUser', 'CurrencyManager'];

BCPPriceListCtrl.getCompanyForLoggedUser = function($q, $route, $rootScope, FrontCreatorCompanyForLoggedUser){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorCompanyForLoggedUser.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}